require( "quest/m3_apartment/convout.lua" );
combine_speech_tables();

local listPos = { x = 650, y = 450 };
local origin = { x = 0, y = 0 };
local offScreen = { x = -500, y = -500 };
local comboList = { };
local tiles = { };
local using_reveal_pen = false;
local correctCombo = { 6, 6, 4, 2, 7, 3 };

local safe_combo_info = 
{
	header = "text_combo_header";
	combo_name = "SAFE_COMBO_TEXT_";
	box_name = "SAFE_COMBO_BOX_";
	button_up_name = "SAFE_COMBO_BUTTON_UP_";
	button_down_name = "SAFE_COMBO_BUTTON_DOWN_";
	combo_pos = { x = 485, y = 150 };
	combo_offset = { x = 0, y = 55 };
	box_offset = { x = 210, y = -15 };
	button_offset_up = { x = 260, y = -25 };
	button_offset_down = { x = 260, y = -5 };
	combos = 
	{
		"text_combo_1",
		"text_combo_2",
		"text_combo_3",
		"text_combo_4",
		"text_combo_5",
		"text_combo_6",
	};
};

safe_combo_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	color_over = { a = 1, r = 0, g = 0, b = 0 },
	y = 0,
	x = 0,
	w = 300,
	h = 30,
	bubble = false,
	lineheight = 30,
	outline_size = 0,
	font = "fonts/franklingothic_demicond.mvec"; 
	anchor = ANCHOR.CENTER;
	halign = HALIGN.LEFT;
};

function conv_flo(flo)
	flo:SetMode(MODE.CUTSCENE);
	if not quest_added("unlock_drawer") then
		run_super_conversation(flo, "quip_find_combination");
	elseif game:Get( "got_desk_key" ) < 1 then
		run_super_conversation(flo, "quip_drawer_locked");
	elseif quest_complete("unlock_drawer") and game:Get( "has_reveal_pen" ) < 1 then
		run_super_conversation(flo, "quip_revealer_pen");
	elseif quest_added("figure_out_clues") and not quest_complete("figure_out_clues") then
		run_super_conversation(flo, "quip_code_revealed");
	else
		run_super_conversation(flo, "quip_flo_general");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:SetWalkSpeed(flo_speed);
		
		actor:JumpToNamedPoint("entrance");
		actor:FaceNow(DIR.S);
		actor:WalkTo("flo");
		wait_walkto();
		
		actor:Face(DIR.E);
		delay(30);
		
		if ( game:Get( "visited_apartment" ) ~= 1 ) then
			actor:StartProc(find_combination);
			game:Set( "visited_apartment", 1 );	
		end
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(conv_flo);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function gotopancake(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if quest_complete("figure_out_clues") then
		flo:WalkTo("entrance");
		wait_walkto();
		goto_scene(flo, "m3_pancake");
	else
		if not quest_complete("unlock_drawer") then
			run_super_conversation(flo, "conv_exit_no_code");
		elseif game:Get( "has_reveal_pen" ) < 1 then
			run_super_conversation(flo, "conv_exit_no_revealer");
		else
			local entered_value = true;
			for index = 1, 6 do
				local currentValue = game:Get( "combo_" .. tostring(index) );
				if ( currentValue < 1 ) then
					entered_value = false;
				end
			end
			if entered_value == false then
				run_super_conversation(flo, "conv_exit_incomplete_code");
			else
				run_super_conversation(flo, "conv_exit_wrong_code");
			end
		end
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

to_pancake_spec = 
{
	name = "TO_PANCAKE";
	halo = "front_door";
	depth = 100;
	cursor = "cursor_arrow_ne";
	goto_fn = gotopancake;
}

key_spec =
{
	name = "KEY";
	halo = "key";
	gfx = { image = "apt_desk_key" };
	
	command = function(actor)
		actor:SetDepthValue(500);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			scene.KEY:Expire();
			addInventory(inv_desc_key);
			game:Set( "got_desk_key", 1 );
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end;
}

desk_drawer_spec =
{
	name = "DESK_DRAWER";
	halo = "desk_drawer";
	gfx = { image = "apt_drawer_closed" };
	
	command = function(actor)
		actor:SetDepthValue( 50 );		
		if ( game:Get( "has_combo_paper" ) == 1 ) then
			actor:LoadImage("apt_open_drawer");
		end
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(clicked_on_drawer);
	end;
	
	on_use_inv = function(item, flo, actor)		
		if ( item == "key" ) then
			flo:StartProc(unlock_drawer);
		end
	end
}	

pen_holder_spec =
{
	name = "PEN_HOLDER";
	halo = "apt_pen_holder";
	
	command = function(actor)
		actor:SetDepthValue(501);
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(get_revealer);
		actor:Expire();
	end;
	
	on_use_inv = function(item, flo, actor)		

	end
}	

function spawn_safe_combo_paper(flo)
	scene:Spawn(safe_combo_paper_spec);
	scene:Spawn(safe_combo_paper_back_spec);
	
	for i = 1, table.getn(safe_combo_info.combos) do
		table.insert ( comboList, spawn_safe_combo_text(i) );
		table.insert ( comboList, spawn_safe_combo_box(i) );
		table.insert ( comboList, spawn_safe_combo_button_up(i) );
		table.insert ( comboList, spawn_safe_combo_button_down(i) );
	end
	
	show_combo(flo);
	
	if ( game:Get( "paper_revealed" ) ~= 1 ) then
		show_tiles();
	end
end

function kill_safe_combo_paper()
	scene.SAFE_COMBO_PAPER:Expire();
	scene.SAFE_COMBO_PAPER_BACK:Expire();
	
	for i,j in pairs(comboList) do
		j:Expire();
	end
	
	comboList = {};
	
	hide_tiles();
end

safe_combo_paper_spec =
{
	name = "SAFE_COMBO_PAPER";
	halo = "safe_combo";
	gfx = { image = "safe_combo_revealed" }; -- blank
	
	command = function(actor)
		actor:SetDepthValue( 600 );
		if using_reveal_pen == false then
			actor:SetPointAtCursor("cursor");
		end
		
		actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
		actor:AddFlag(AFLAG.AFLAG_NO_VOX);
		actor:ModifySaySpec(safe_combo_text_spec);
		actor:ModifySaySpec
		{
			x = 540,
			y = 90,
			w = 220,
			h = 80,
			lineheight = 30,
			halign = HALIGN.CENTER,
		};
		
		actor:Say(safe_combo_info.header);
	end;
	
	on_use_inv = function(item, flo, actor)		
		if ( item == "revealer" ) then
		end
		return RESPONSE.INV_HANDLED;
	end
}

safe_combo_paper_back_spec = 
{
	name = "SAFE_COMBO_PAPER_BACK";
	halo = "safe_combo_paper_back";
	gfx = { image = "safe_combo_blank" };
	
	command = function(actor)
		if using_reveal_pen == false then
			actor:SetPointAtCursor("cursor_exit");
		end
		actor:SetDepthValue(599);
		
			
		actor.on_arrive = function(flo, actor)
			if not using_reveal_pen then
				kill_safe_combo_paper();
				scene:Spawn(combo_paper_small_spec);
				actor:Expire();
			end
		end;
		
		actor.on_use_inv = function(item, flo, actor)
			game:ClearInvUsage();
			actor.on_arrive(flo, actor);
			return RESPONSE.INV_HANDLED;
		end;
	end;
};

function spawn_safe_combo_text(num)
	return scene:Spawn
	{
		name = safe_combo_info.combo_name .. num;
		
		command = function(actor)
			actor:JumpToPoint
			{
				x = safe_combo_info.combo_pos.x + ((num-1)*safe_combo_info.combo_offset.x),
				y = safe_combo_info.combo_pos.y + ((num-1)*safe_combo_info.combo_offset.y)
			};
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:ModifySaySpec(safe_combo_text_spec);
			actor:ModifySaySpec
			{
				w = 220,
				h = 30,
				lineheight = 16,
				halign = HALIGN.CENTER,
				fixed = true,
			};
			
			actor:Say(safe_combo_info.combos[num]);
		end;
	};
end

function spawn_safe_combo_box(num)
	return scene:Spawn
	{
		name = safe_combo_info.box_name .. num;
		gfx = { image = "combo_square" };
		
		command = function(actor)
			actor:JumpToPoint
			{
				x = safe_combo_info.combo_pos.x + ((num-1)*safe_combo_info.combo_offset.x) + safe_combo_info.box_offset.x,
				y = safe_combo_info.combo_pos.y + ((num-1)*safe_combo_info.combo_offset.y) + safe_combo_info.box_offset.y
			};
			actor:AddFlag(AFLAG.AFLAG_TEXT_ON_ACTOR);
			actor:AddFlag(AFLAG.AFLAG_NO_VOX);
			actor:ModifySaySpec(safe_combo_text_spec);
			actor:ModifySaySpec
			{
				w = 53,
				h = 53,
				lineheight = 20,
				halign = HALIGN.CENTER,
				fixed = true,
			};
			
			actor:SayRaw("0");
		end;
	};
end

function spawn_safe_combo_button_up(num)
	return scene:Spawn
	{
		name = safe_combo_info.button_up_name .. num;
		gfx = { image = "combo_arrow_up_up" };
		halo = "combo_arrow";
		
		command = function(actor)
			actor:JumpToPoint
			{
				x = safe_combo_info.combo_pos.x + ((num-1)*safe_combo_info.combo_offset.x) + safe_combo_info.button_offset_up.x,
				y = safe_combo_info.combo_pos.y + ((num-1)*safe_combo_info.combo_offset.y) + safe_combo_info.button_offset_up.y
			};
			actor:SetDepthValue(601);
			
			actor.over = false;
			
			if game:Get( "paper_revealed" ) ~= 1 then
				actor:DumpZone();
			end
		end;
		
		on_arrive = function(flo, actor)
			currentValue = game:Get( "combo_" .. tostring(num) );			
			if ( currentValue == 9 ) then
				currentValue = 0;
			else
				currentValue = currentValue + 1;
			end				
			game:Set( "combo_" .. tostring(num), currentValue );
			flo:StartProc(show_combo);
			
			actor:StartProc(function(actor)
				actor:LoadImage("combo_arrow_up_down");
				sfx:PlaySFX("audio/sfx/buttonclick");
				delay(5);
				actor:LoadImage("combo_arrow_up_up");
				
				if actor.over then
					actor:LoadImage("combo_arrow_up_rollover");
				else
					actor:LoadImage("combo_arrow_up_up");
				end
			end);
		end;
		
		point_at_fn = function(actor, enter)
			if enter then
				actor:LoadImage("combo_arrow_up_rollover");
				sfx:PlaySFX("audio/sfx/button_rollover");
				actor.over = true;
			else
				actor:LoadImage("combo_arrow_up_up");
				actor.over = false;
			end
		end;
	};
end

function spawn_safe_combo_button_down(num)
	return scene:Spawn
	{
		name = safe_combo_info.button_down_name .. num;
		gfx = { image = "combo_arrow_down_up" };
		halo = "combo_arrow";
		
		command = function(actor)
			actor:JumpToPoint
			{
				x = safe_combo_info.combo_pos.x + ((num-1)*safe_combo_info.combo_offset.x) + safe_combo_info.button_offset_down.x,
				y = safe_combo_info.combo_pos.y + ((num-1)*safe_combo_info.combo_offset.y) + safe_combo_info.button_offset_down.y
			};
			actor:SetDepthValue(601);
			
			actor.over = false;
			
			if game:Get( "paper_revealed" ) ~= 1 then
				actor:DumpZone();
			end
			
		end;
		
		on_arrive = function(flo, actor)
			currentValue = game:Get( "combo_" .. tostring(num) );
			if ( currentValue == 0 ) then
				currentValue = 9;
			else
				currentValue = currentValue - 1;
			end				
			game:Set( "combo_" .. tostring(num), currentValue );
			flo:StartProc(show_combo);
			
			actor:StartProc(function(actor)
				actor:LoadImage("combo_arrow_down_down");
				sfx:PlaySFX("audio/sfx/buttonclick");
				delay(5);
				if actor.over == true then
					actor:LoadImage("combo_arrow_down_rollover");
				else
					actor:LoadImage("combo_arrow_down_up");
				end
			end);
		end;
		
		point_at_fn = function(actor, enter)
			if enter then
				actor:LoadImage("combo_arrow_down_rollover");
				sfx:PlaySFX("audio/sfx/button_rollover");
				actor.over = true;
			else
				actor:LoadImage("combo_arrow_down_up");
				actor.over = false;
			end
		end;
	};
end

combo_paper_small_spec =
{
	name = "COMBO_PAPER_SMALL";
	halo = "combo_small";
	gfx = { image = "combo_blank_small" };
	
	command = function(actor)
		actor:JumpToPoint(listPos);
		actor:SetDepthValue( 700 );		
		if game:Get( "paper_revealed" ) == 1 then
			actor:LoadImage( "combo_revealed_small" );
		end
	end;
	
	on_arrive = function(flo, actor)
		flo:StartProc(spawn_safe_combo_paper);
		actor:Expire();
	end;
	
	on_use_inv = function(item, flo, actor)		

	end
}	

closet_spec =
{
	name = "CLOSET";
	halo = "closet";
	gfx = { anim = "anim/m3_apartment/closet" };
	
	command = function(actor)
		actor:SetDepthValue( 200 );
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		if game:Get("apt_closet_open") < 1 then 
			-- load closed closet?
			actor:PlayAnim("Closed");
		else
			actor:PlayAnim("Opened");
		end
	end;
	
	on_arrive = function(flo, actor)
		if game:Get("apt_closet_open") < 1 then 
			actor:PlayAnim("Open");
			sfx:PlaySFX("audio/sfx/apt_closet");	
			scene:Spawn(shoe_basket_spec);
			game:Set("apt_closet_open", 1);
			
			if game:Get("first_time_opened_closed") < 1 then
				game:Set("first_time_opened_closed", 1);
				convproc("FLO", "conv_open_closet");
			end
		else
			actor:PlayAnim("Close");
			sfx:PlaySFX("audio/sfx/apt_closet");
			scene.SHOE_BASKET:Expire();
			game:Set("apt_closet_open", 0);
		end
	end;
}

shoe_basket_spec =
{
	name = "SHOE_BASKET";
	halo = "apt_shoe_basket";
	gfx = { image = "apt_shoe_basket" };
	
	command = function(actor)		
		actor:SetDepthValue( 300 );	
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 6 );
	end;
}

remote_spec =
{
	name = "REMOTE";
	halo = "apt_remote";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 5 );
	end;
}

telephone_spec =
{
	name = "TELEPHONE";
	halo = "apt_telephone";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 4 );
	end;
}

painting_spec =
{
	name = "PAINTING";
	halo = "apt_painting";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 3 );
	end;
}

calendar_spec =
{
	name = "CALENDAR";
	halo = "apt_calendar";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 2 );
	end;
}

bookshelf_spec =
{
	name = "BOOKSHELF";
	halo = "apt_bookshelf";
	
	command = function(actor)
		actor:SetDepthValue(100);
	end;
	
	on_arrive = function(flo, actor)
		show_closeup( 1 );
	end;
}

function show_closeup( closeup_num )
	sfx:PlaySFX("audio/sfx/apt_closeup");
	game:Set("m3_apartment_closeup_num", closeup_num);
	scene:ChainToSubScene("m3_apartment_closeup");
	
	if not quest_added("figure_out_clues") then
		scene.FLO:StartProc(function(flo)
			flo:SetMode(MODE.CUTSCENE);
			wait_subscene();
			local conv = "";
			if closeup_num == 1 then
				conv = "conv_books_no_code";
			elseif closeup_num == 2 then
				conv = "conv_calendar_no_code";
			elseif closeup_num == 3 then
				conv = "conv_painting_no_code";
			elseif closeup_num == 4 then
				conv = "conv_phone_no_code";
			elseif closeup_num == 5 then
				conv = "conv_remote_no_code";
			else -- closeup_num == 6 then
				conv = "conv_shoes_no_code";
			end
			run_super_conversation(flo, conv);
			flo:SetMode(MODE.FOLLOWCLICKS);
		end);
	end
end

function leave(flo)
	flo:WalkTo("entrance");
	wait_walkto();	
	goto_scene(flo, "m3_pancake");
end

function find_combination(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_apt_intro");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function dog_talk(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_dog");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function unlock_drawer(flo)
	flo:SetMode(MODE.CUTSCENE);
	sfx:PlaySFX("audio/sfx/apt_drawer");
	scene.DESK_DRAWER:LoadImage("apt_open_drawer1");
	BAG_INV:RemoveInventory("key");
	game:Set( "has_combo_paper", 1 );
	
	run_super_conversation(flo, "conv_drawer_open");
	
	complete_quest("unlock_drawer", false);
	wait_subscene();
	
	scene.DESK_DRAWER:LoadImage("apt_open_drawer2");
	scene:Spawn(combo_paper_small_spec);
	
	if ( game:Get( "has_reveal_pen" ) == 1 ) then
		flo:StartProc(use_reveal_paper);
	else
		flo:StartProc(reveal_paper);
	end
end

function clicked_on_drawer(flo)
	flo:SetMode(MODE.CUTSCENE);
	if not quest_complete("unlock_drawer") then
		run_super_conversation(flo, "conv_drawer_locked");
		add_quest("unlock_drawer", false);
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_revealer(flo)
	flo:SetMode(MODE.CUTSCENE);
	addInventory(inv_desc_revealer);
	game:Set( "has_reveal_pen", 1 );
	run_super_conversation(flo, "conv_revealer_pen");
	
	complete_quest("find_revealer", false);
	
	if ( game:Get( "has_combo_paper" ) == 1 ) then 
		flo:StartProc(use_reveal_paper);
	else
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

function use_reveal_paper(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	complete_quest("find_code_paper", false);
	
	run_super_conversation(flo, "conv_use_revealer");
	
	using_reveal_pen = true;
	spawn_safe_combo_paper(flo);
	scene.COMBO_PAPER_SMALL:Expire();
	--run_super_conversation(flo, "quip_use_revealer");
	scene.DESK_DRAWER:LoadImage("apt_drawer_closed");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function reveal_paper(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if not quest_complete("find_code_paper") then
		complete_quest("find_code_paper", false);
		run_super_conversation(flo, "conv_find_paper");
	else	
		spawn_safe_combo_paper(flo);
		scene.COMBO_PAPER_SMALL:Expire();
		run_super_conversation(flo, "quip_revealer_pen");
		kill_safe_combo_paper();
		scene:Spawn(combo_paper_small_spec);
	end
	
	add_quest("find_revealer", false);
	wait_subscene();
	
	scene.DESK_DRAWER:LoadImage("apt_drawer_closed");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function revealed_code(flo)
	flo:SetMode(MODE.CUTSCENE)
	using_reveal_pen = false;
	run_super_conversation(flo, "conv_code_revealed");
	run_super_conversation(flo, "quip_code_revealed");
	add_quest("figure_out_clues", false);
	
	kill_safe_combo_paper();
	
	scene:Spawn(combo_paper_small_spec);
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function show_tiles()
	local xPos = 494;
	local yPos = 125;
	
	for i = 1, 9 do
		for j = 1, 11 do
			local index = (j-1) * 10 + i;
			tiles[index] = scene:Spawn( get_tile_spec( i, j, index ) );
			tiles[index]:JumpToPoint( { x = xPos + (i - 1) * 32, y = yPos + (j-1) * 32 } );
		end
	end
end

function get_tile_spec( i, j, index )
	return
	{
		name = "TILE_" .. tostring(index);
		halo = "tile";
		gfx = { image = "tile" };

		command = function(actor)
			actor:SetDepthValue( 1000 );
			actor:JumpToPoint( offScreen );
			actor.i = i;
			actor.j = j;
			if using_reveal_pen == false then
				actor:SetPointAtCursor("cursor");
			end
		end;
		
		point_at_fn = function(actor, enter)	
			if ( game:GetInvUsage() == "revealer" ) then			
				tiles[index] = nil;
				sfx:PlaySFX("audio/sfx/apt_revealer_" .. math.random(1,4));
				actor:Expire();
				local done = true;
				for k,l in pairs(tiles) do
					if ( l ~= nil ) then
						done = false;
					end
				end
				if ( done ) then				
					--scene.COMBO_PAPER_SMALL:LoadImage( "combo_revealed_small" );
					BAG_INV:RemoveInventory("revealer");
					game:Set( "paper_revealed", 1 );
					scene.FLO:StartProc(revealed_code);
				end
			end
		end		
	}
end

function hide_tiles()
	if ( game:Get( "paper_revealed" ) ~= 1 ) then
		for k,l in pairs(tiles) do
			if ( l ~= nil ) then
				l:Expire();
			end
		end
	end
end

function show_combo(flo)
	for i = 1, table.getn(safe_combo_info.combos) do
		scene[safe_combo_info.box_name .. i]:SayRaw( game:Get("combo_" .. i ) );
	end
	if ( game:Get( "have_safe_combo" ) ~= 1 ) then
		local correct = true;
		for index = 1, 6 do
			local currentValue = game:Get( "combo_" .. tostring(index) );
			if ( currentValue ~= correctCombo[index] ) then
				correct = false;
			end
		end
		if ( correct ) then
			game:Set( "have_safe_combo", 1 );
			flo:StartProc(quest);
		end
	end
end

function quest(flo)
	flo:SetMode(MODE.CUTSCENE);
	complete_quest("figure_out_clues", false);
	add_quest("code_number");
	wait_subscene();
	kill_safe_combo_paper();
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_combo_arrow_spec( index, direction )
	return
	{
		name = "COMBO_ARROW_" .. tostring(index) .. "_" .. direction;
		halo = "combo_arrow";

		command = function(actor)
			actor:SetDepthValue( 800 );
		end;

		on_arrive = function(flo, actor)
			currentValue = game:Get( "combo_" .. tostring(index) );
			if ( direction == "up" ) then				
				if ( currentValue == 9 ) then
					currentValue = 0;
				else
					currentValue = currentValue + 1;
				end				
			else
				if ( currentValue == 0 ) then
					currentValue = 9;
				else
					currentValue = currentValue - 1;
				end				
			end
			game:Set( "combo_" .. tostring(index), currentValue );
			show_combo(flo);
		end;
	}
end

function get_combo_square_spec( index )
	return
	{
		name = "COMBO_SQUARE_" .. tostring(index);
		halo = "combo_square";

		command = function(actor)
			actor:SetDepthValue( 800 );
			actor:ModifySaySpec
			{
				color = { a = 1, r = 0, g = 0, b = 0 },
				y = 19,
				x = -27,
				w = 90,
				h = 25,
				bubble = false,
				outline_size = 0,
				font = "fonts/garamondpremierpro.mvec"; 
				anchor = ANCHOR.CENTER
			};
			
			actor:SetPointAtCursor("cursor");
		end;
		
		on_use_inv = function(item, flo, actor)
			return RESPONSE.INV_HANDLED;
		end;
	}
end

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/dressshopmusic.ogg", true);
		scene:SetRoomScale(300, 550, 1.0, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end		
		
		if game:Get( "has_combo_paper" ) > 0 and not quest_complete("figure_out_clues") then
			scene:Spawn(combo_paper_small_spec);
		end
			
		if game:Get( "got_desk_key" ) < 1 then
			scene:Spawn(key_spec);
		end
		
		if game:Get( "has_reveal_pen" ) < 1 then
			scene:Spawn(pen_holder_spec);
		end
		
		if game:Get("apt_closet_open") > 0 then
			scene:Spawn(shoe_basket_spec);
		end
		
		spawn_nav_arrow(to_pancake_spec);
		spawn_simple_hotspot("dog");
		spawn_simple_hotspot("lamp");
		spawn_simple_hotspot("vacuum");
		spawn_simple_hotspot("plant");
		spawn_simple_hotspot("clock");
		spawn_simple_hotspot("ice_cream");
		spawn_simple_hotspot("TV");
		spawn_simple_hotspot("sofa");
		spawn_simple_hotspot("drawer2");
		spawn_simple_hotspot("rubiks");
		
		game:SetString("map_position", "m3_apartment");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces1", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "apt_bookshelf", 200 },
		{ "apt_painting", 195 },
		{ "apt_pen_holder", 400 },
		{ "apt_remote", 400 },
		{ "apt_telephone", 200 },
		
		{ "apt_sofa", 400 },
		{ "tv_coffee", 500 };
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		desk_drawer_spec,
		closet_spec,
		remote_spec,
		telephone_spec,
		painting_spec,
		calendar_spec,
		bookshelf_spec,
		
		scene_setup,
	};
};
